// Fit cure models
// stored results
//    - rmst at 3 years
//    - mean survival
//    - AIC/BIC
//    - convergence


clear

// change to relavent folder
cd "Z:\TSD Simulation\tsd_simulation\Analysis_of_simulations\Cure"


// program to extract results from streg models
capture program drop get_bground_results_cure
program define get_bground_results_cure
	syntax, dist(string)
	capture drop s3 
	capture drop s80
	capture drop S0*
	capture drop surv_b*
	// background rates
	include ../../Scenario_Parameters/background_mortality_rate_gompertz.do							
	
	// rmst3
	drop _t
	range _t 0 3 1000
	predict s3, survival timevar(_t)
	replace s3=1 if _t==0
	
	gen surv_background=.
	levelsof _t, local(tlevs)
	gen double S0 = exp(-`lambda_gomp'/`gamma_gomp' *(exp(`gamma_gomp'*(age)) - 1))
	
	local j=0
	foreach t of local tlevs {
		local j=`j'+1	
		capture drop surv_background_temp* S0_tvar
		gen double S0_tvar = exp(-`lambda_gomp'/`gamma_gomp' *(exp(`gamma_gomp'*(age+`t')) - 1))
		gen surv_background_temp=S0_tvar/S0 
		egen surv_background_temp2=mean(surv_background_temp)
		replace surv_background=surv_background_temp2  in `j'
	}
	
	capture drop surv_background_temp*
	replace s3=s3*surv_background
	capture integ s3 _t
	c_local rmst3_`dist'= cond("`r(integral)'"!="","`r(integral)'",".")
	
	
	// meansurv
	drop _t
	drop surv_background
	gen surv_background=.
	range _t 0 80 1000
	
	levelsof _t, local(tlevs)
	
	predict s80, survival timevar(_t)
	replace s80=1 if _t==0
	drop S0_tvar
	
	local j=0
	foreach t of local tlevs {
		local j=`j'+1	
		capture drop surv_background_temp* S0_tvar
		gen double S0_tvar = exp(-`lambda_gomp'/`gamma_gomp' *(exp(`gamma_gomp'*(age+`t')) - 1))
		gen surv_background_temp=S0_tvar/S0 
		egen surv_background_temp2=mean(surv_background_temp)
		replace surv_background=surv_background_temp2 in `j'
	}
	
	capture drop surv_background_temp*
	replace s80=s80*surv_background
	capture integ s80 _t	
	c_local meansurv_`dist' = cond("`r(integral)'"!="","`r(integral)'",".")
	replace _t = old_t

end



set trace off 
// simulation number
local j 1 
// Maximum number of degrees of freedom for fitting an stpm2 model. Code below loops over 1,2,3,...,df_max

// Scenario
foreach scen in 1 2 3 4 { 
	// sample size 
	foreach ss in  100 500 {

		// Low and medium survival
		foreach S in  1 2 {

		// Different frailty effects
			foreach F in 1 2 {

				// only run if results dataset does not exist
				if(fileexists("Scenario`scen'_S`S'_SS`ss'_F`F'.dta")!=1){
				
					di _newline "Scenario`scen'_S`S'_SS`ss'_F`F'"
					cons drop _all
					quietly {
						//postfile
						postutil clear
						local newvars
					foreach  dist in weibull df3 df3time10 {
						foreach x in rmst3 meansurv {
							local newvars `newvars' `x'_`dist'
						}
					}
						di "`newvars'"
						postfile simcure `newvars' using Scenario`scen'_S`S'_SS`ss'_F`F'.dta,replace
					
						// loop over datasets
						forvalues j = 1/1000 {
							cons drop _all
							// load and analyse
							use ../../Simulated_Data/Scenario`scen'_S`S'_SS`ss'_F`F'/sim`j', clear

							// background rates
							include ../../Scenario_Parameters/background_mortality_rate_gompertz.do							
							stset t d
							clonevar old_t = _t	
							gen double rate = `lambda_gomp' *(exp(`gamma_gomp'*(age+t)))
							
						foreach dist in weibull df3 df3time10 {
							
							if "`dist'"=="df3" {
								capture stpm2, df(3) bhaz(rate) scale(h) iter(30) cure
							}
							if "`dist'"=="df3time10" {
								capture stpm2, df(3) bknots(0.0002 10) bhaz(rate) scale(h) iter(30) cure
							}							
							if "`dist'"=="weibull" {
								capture strsmix, distribution(weibull) bhaz(rate) iter(30) link(logistic)
							}
							
								if _rc==0 { 
									if e(converged)==1 {
										get_bground_results_cure, dist(`dist')
									}
									else {
										  local rmst3_`dist'=. 
										  local meansurv_`dist'=.
									}
								}
								else {
									local rmst3_`dist'=. 
									local meansurv_`dist'=.
								}
		
							}
							
							// post values
							local postvals
						foreach dist in weibull df3 df3time10 {
							foreach x in rmst3 meansurv {
								local postvals `postvals' (``x'_`dist'')
							}					
						}
						
							post simcure `postvals'
							noisily di "." _continue
							
						}
						postclose simcure
          }
        }
      }
    }
  }
}


